<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights\Resource;

use Google\Service\Contactcenterinsights\GoogleCloudContactcenterinsightsV1FeedbackLabel;
use Google\Service\Contactcenterinsights\GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse;
use Google\Service\Contactcenterinsights\GoogleProtobufEmpty;

/**
 * The "feedbackLabels" collection of methods.
 * Typical usage is:
 *  <code>
 *   $contactcenterinsightsService = new Google\Service\Contactcenterinsights(...);
 *   $feedbackLabels = $contactcenterinsightsService->projects_locations_authorizedViewSet_authorizedViews_conversations_feedbackLabels;
 *  </code>
 */
class ProjectsLocationsAuthorizedViewSetAuthorizedViewsConversationsFeedbackLabels extends \Google\Service\Resource
{
  /**
   * Create feedback label. (feedbackLabels.create)
   *
   * @param string $parent Required. The parent resource of the feedback label.
   * @param GoogleCloudContactcenterinsightsV1FeedbackLabel $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string feedbackLabelId Optional. The ID of the feedback label to
   * create. If one is not specified it will be generated by the server.
   * @return GoogleCloudContactcenterinsightsV1FeedbackLabel
   * @throws \Google\Service\Exception
   */
  public function create($parent, GoogleCloudContactcenterinsightsV1FeedbackLabel $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], GoogleCloudContactcenterinsightsV1FeedbackLabel::class);
  }
  /**
   * Delete feedback label. (feedbackLabels.delete)
   *
   * @param string $name Required. The name of the feedback label to delete.
   * @param array $optParams Optional parameters.
   * @return GoogleProtobufEmpty
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], GoogleProtobufEmpty::class);
  }
  /**
   * Get feedback label. (feedbackLabels.get)
   *
   * @param string $name Required. The name of the feedback label to get.
   * @param array $optParams Optional parameters.
   * @return GoogleCloudContactcenterinsightsV1FeedbackLabel
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], GoogleCloudContactcenterinsightsV1FeedbackLabel::class);
  }
  /**
   * List feedback labels. (feedbackLabels.listProjectsLocationsAuthorizedViewSetA
   * uthorizedViewsConversationsFeedbackLabels)
   *
   * @param string $parent Required. The parent resource of the feedback labels.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string filter Optional. A filter to reduce results to a specific
   * subset. Supports disjunctions (OR) and conjunctions (AND). Automatically
   * sorts by conversation ID. To sort by all feedback labels in a project see
   * ListAllFeedbackLabels. Supported fields: * `issue_model_id` *
   * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time`
   * * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI,
   * TOPIC_MODELING
   * @opt_param int pageSize Optional. The maximum number of feedback labels to
   * return in the response. A valid page size ranges from 0 to 100,000 inclusive.
   * If the page size is zero or unspecified, a default page size of 100 will be
   * chosen. Note that a call might return fewer results than the requested page
   * size.
   * @opt_param string pageToken Optional. The value returned by the last
   * `ListFeedbackLabelsResponse`. This value indicates that this is a
   * continuation of a prior `ListFeedbackLabels` call and that the system should
   * return the next page of data.
   * @return GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse
   * @throws \Google\Service\Exception
   */
  public function listProjectsLocationsAuthorizedViewSetAuthorizedViewsConversationsFeedbackLabels($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse::class);
  }
  /**
   * Update feedback label. (feedbackLabels.patch)
   *
   * @param string $name Immutable. Resource name of the FeedbackLabel. Format: pr
   * ojects/{project}/locations/{location}/conversations/{conversation}/feedbackLa
   * bels/{feedback_label}
   * @param GoogleCloudContactcenterinsightsV1FeedbackLabel $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string updateMask Required. The list of fields to be updated.
   * @return GoogleCloudContactcenterinsightsV1FeedbackLabel
   * @throws \Google\Service\Exception
   */
  public function patch($name, GoogleCloudContactcenterinsightsV1FeedbackLabel $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('patch', [$params], GoogleCloudContactcenterinsightsV1FeedbackLabel::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsAuthorizedViewSetAuthorizedViewsConversationsFeedbackLabels::class, 'Google_Service_Contactcenterinsights_Resource_ProjectsLocationsAuthorizedViewSetAuthorizedViewsConversationsFeedbackLabels');
